//-----------------------------------------------------------------------------
//Copyright  2000-2003 TogetherSoft Corporation, a wholly owned subsidiary of Borland Software Corporation. All rights reserved. All patents pending.
//-----------------------------------------------------------------------------
namespace CSCashSales.data_objects
{
    using System;
	using System.Collections;

    /// <summary>
    /// Represents some object that can have some attributes
    /// for visual presentation.
    /// </summary>
    public interface IPresentView
    {
		/// <summary>
		/// Indicates whether the object has linear presentable attributes.
		/// </summary>
		bool hasLinearAttributes();

		/// <summary>
		/// Indicates whether the object has table presentable attributes.
		/// </summary>
		bool hasTableAttributes();

		/// <summary>
		/// Returns the number of linear presentable attributes.
		/// </summary>
		int getLinearAttrCount();

		/// <summary>
		/// Returns the name of a linear presentable attribute.
		/// </summary>
		/// <param name="attr"> The attribute code </param>
		String getLinearAttrName( int attr );

		/// <summary>
		/// Returns the value of a linear presentable attribute.
		/// </summary>
		/// <param name="attr"> The attribute code </param>
		String getLinearAttrValue( int attr );

		/// <summary>
		/// Returns the number of table presentable attributes.
		/// </summary>
		int getTableAttrCount();

		/// <summary>
		/// Returns the size of attribute table.
		/// </summary>
		int getTableRowCount();

		/// <summary>
		/// Returns the name of a table presentable attribute.
		/// </summary>
		/// <param name="attr"> The attribute code </param>
		String getTableAttrName( int attr );

		/// <summary>
		/// Returns the value of a table presentable attribute.
		/// </summary>
		/// <param name="attr"> The attribute code </param>
		/// <param name="row"> The table row </param>
		String getTableAttrValue( int attr, int row );
        
    }
}
